﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Reflection;
using System.Collections.ObjectModel;
using CommunicationSupport;
using System.Web.SessionState;

namespace ServiceCommunication
{
    internal class WCFHandler : IHttpHandler, IRequiresSessionState
    {
        #region Constructors

        public WCFHandler() { }
        public WCFHandler(Type serviceType, string serviceMethodName)
        {
            ServiceType = serviceType;
            ServiceMethodName = serviceMethodName;
        }

        #endregion

        #region Properties

        public Type ServiceType { get; set; }
        public string ServiceMethodName { get; set; }

        #endregion

        #region IHttpHandler Members

        public bool IsReusable
        {
            get { throw new NotImplementedException(); }
        }

        public void ProcessRequest(HttpContext context)
        {
            ServiceRequestProcessor.ProcessRequest(context, ServiceType, ServiceMethodName);
        }

        #endregion

     }
}
